﻿using AZVIC.Ei8htPOS.BAL;
using AZVIC.Ei8htPOS.Entities;
using AZVIC.Ei8htPOS.Utilities;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace AZVIC.Ei8htPOS.WebUI.Admin.Masters.SubCategory
{
    public partial class EditSubCategory : System.Web.UI.Page
    {
        private ProductSubCategory mySubCategory;

        protected void Page_Load(object sender, EventArgs e)
        {
            WebSession.RedirectToAdminDashBoard(false);

            if (!IsPostBack)
            {
                BindProductCategory();
                if (Request.QueryString["UniqueID"] != null)
                {
                    hdProductSubCategoryID.Value = Request.QueryString["UniqueID"].ToString();
                    ShowProductSubCategory();
                }
            }
        }

        private void BindProductCategory()
        {
            List<Entities.ProductCategory> CategoryList = ProductCategoryBL.GetList(Guid.Empty, string.Empty);
            if (CategoryList != null && CategoryList.Count > 0)
            {
                CategoryList = CategoryList.Where(a => a.IsActive).ToList<Entities.ProductCategory>();
            }
            WebUtilities.FillDropDownList(ddlCategory, CategoryList, "UniqueID", "CategoryName");
        }

        private void ShowProductSubCategory()
        {
            mySubCategory = ProductSubCategoryBL.GetItem(Guid.Parse(hdProductSubCategoryID.Value.Trim()), Guid.Empty, string.Empty);
            if (mySubCategory != null)
            {
                hdProductSubCategoryID.Value = mySubCategory.UniqueID.ToString();
                ddlCategory.SelectedIndex = ddlCategory.Items.IndexOf(ddlCategory.Items.FindByValue(mySubCategory.ProductCategoryID.ToString()));
                txtSubCategoryName.Text = mySubCategory.SubCategoryName;
                txtSequenceNo.Text = mySubCategory.SequenceNo.ToString();
                chkIsActive.Checked = mySubCategory.IsActive;
            }
        }

        protected void btnSave_Click(object sender, EventArgs e)
        {
            if (ValidatePageValue())
            {
                mySubCategory = new ProductSubCategory();
                if (hdProductSubCategoryID.Value.Trim().Length == 0)
                    mySubCategory.Mode = GlobalConfigurations.Mode.Insert;
                else
                {
                    mySubCategory.Mode = GlobalConfigurations.Mode.Update;
                    mySubCategory.UniqueID = Guid.Parse(hdProductSubCategoryID.Value.Trim());
                }

                mySubCategory.ProductCategoryID = Guid.Parse(ddlCategory.SelectedValue);
                mySubCategory.SubCategoryName = txtSubCategoryName.Text.Trim();
                mySubCategory.SequenceNo = int.Parse(txtSequenceNo.Text.Trim());
                mySubCategory.IsActive = chkIsActive.Checked;
                mySubCategory.UserAccountID = (WebSession.CurrentAdminUser != null ? WebSession.CurrentAdminUser.UniqueID : Guid.Empty);

                if (ProductSubCategoryBL.Save(mySubCategory))
                {
                    WebUtilities.OpenNewAddEditDialog(this, "Success", "Product Sub Category details has been saved successfully.<br>Do you want to add another Product SUb Category?", this.ResolveClientUrl("~/Admin/Masters/SubCategory/SubCategories.aspx"));
                }
            }
        }

        protected void btnCancel_Click(object sender, EventArgs e)
        {
            Response.Redirect("~/Admin/Masters/SubCategory/SubCategories.aspx", false);
        }

        private bool ValidatePageValue()
        {
            if (ddlCategory.SelectedValue == "0")
            {
                ScriptManager.RegisterStartupScript(this, GetType(), "Verde", "validationMsgBottom('#" + ddlCategory.ClientID + "', 'Please select Product Category Name.'); ", true);
                return false;
            }

            if (!ValidationUtility.ValidateString(txtSubCategoryName.Text.Trim()))
            {
                ScriptManager.RegisterStartupScript(this, GetType(), "Verde", "validationMsgBottom('#" + txtSubCategoryName.ClientID + "', 'Please enter Product Sub Category Name.'); ", true);
                return false;
            }

            if (!ValidationUtility.ValidateInt(txtSequenceNo.Text.Trim()))
            {
                ScriptManager.RegisterStartupScript(this, GetType(), "Verde", "validationMsgBottom('#" + txtSequenceNo.ClientID + "', 'Please enter valid Display Order.'); ", true);
                return false;
            }

            return true;
        }
    }
}